package ru.yandex.chemodan.app.psbilling.core.mail.keydataproviders;

import java.util.function.Function;

import lombok.AllArgsConstructor;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.LocalDate;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.mail.MailContext;
import ru.yandex.chemodan.app.psbilling.core.mail.localization.DateResolver;
import ru.yandex.misc.time.MoscowTime;

@AllArgsConstructor
public class PaymentDeadlineKeyDataProvider extends BaseEmailKeyDataProvider {

    private final DateResolver dateResolver;

    @Override
    protected MapF<String, Function<MailContext, Option<String>>> constructHandlers() {
        return Cf.map(
                "payment_deadline", this::getPaymentDeadline,
                "days_for_payment", this::getDaysForPayment
        );
    }

    private LocalDate getBalanceVoidDateOrThrow(MailContext context) {
        return context.getBalanceVoidDate()
                .orElseThrow(() -> new IllegalStateException("Missing balanceVoidDate"));
    }

    private Option<String> getPaymentDeadline(MailContext context) {
        return Option.of(dateResolver.getLocalizedDate(
                getBalanceVoidDateOrThrow(context),
                context.getLanguageOrThrow()
        ));
    }

    private Option<String> getDaysForPayment(MailContext context) {
        DateTimeZone tz = MoscowTime.TZ;

        LocalDate today = LocalDate.now(tz);
        LocalDate deadline = getBalanceVoidDateOrThrow(context);

        return Option.of(Integer.toString(Days.daysBetween(today, deadline).getDays()));
    }
}
