package ru.yandex.chemodan.app.psbilling.core.mail.keydataproviders;

import java.math.BigDecimal;
import java.util.function.Function;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.billing.users.UserBillingService;
import ru.yandex.chemodan.app.psbilling.core.mail.MailContext;
import ru.yandex.chemodan.app.psbilling.core.products.UserProductManager;
import ru.yandex.chemodan.app.psbilling.core.products.UserProductPeriod;
import ru.yandex.chemodan.app.psbilling.core.products.UserProductPrice;
import ru.yandex.chemodan.app.psbilling.core.texts.TextsManager;
import ru.yandex.inside.utils.Language;

@AllArgsConstructor
public class PriceDataKeyDataProvider extends BaseEmailKeyDataProvider {
    private final UserProductManager userProductManager;
    private final TextsManager textsManager;
    private final UserBillingService userBillingService;

    @Override
    protected MapF<String, Function<MailContext, Option<String>>> constructHandlers() {
        return Cf.map("user_product_price", this::getSum,
                "user_product_currency", this::getCurrency,
                "user_product_period", this::getPeriod);
    }

    private Option<String> getPeriod(MailContext mailContext) {
        return mailContext.getUserProductPriceId()
                .map(userProductManager::findPrice)
                .map(UserProductPrice::getPeriod)
                .map(UserProductPeriod::getPeriod)
                .map(cp -> textsManager.localizedCustomPeriodTitle(
                        cp,
                        mailContext.getLanguage().map(Language::value)
                ));
    }

    private Option<String> getCurrency(MailContext mailContext) {
        return mailContext.getUserProductPriceId()
                .map(userProductManager::findPrice)
                .map(UserProductPrice::getCurrencyCode);
    }

    private Option<String> getSum(MailContext mailContext) {
        return mailContext.getUserProductPriceId()
                .map(userProductManager::findPrice)
                .map(UserProductPrice::getPrice)
                .map(BigDecimal::toString);
    }
}
