package ru.yandex.chemodan.app.psbilling.core.mail.keydataproviders;

import java.util.function.Function;

import lombok.AllArgsConstructor;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.dao.promos.PromoTemplateDao;
import ru.yandex.chemodan.app.psbilling.core.entities.promos.PromoTemplateEntity;
import ru.yandex.chemodan.app.psbilling.core.mail.MailContext;
import ru.yandex.chemodan.app.psbilling.core.mail.localization.DateResolver;
import ru.yandex.chemodan.app.psbilling.core.texts.TextsManager;

@AllArgsConstructor
public class PromoFieldsKeyProvider extends BaseEmailKeyDataProvider {
    private final PromoTemplateDao promoTemplateDao;
    private final TextsManager textsManager;
    private final DateResolver dateResolver;

    @Override
    protected MapF<String, Function<MailContext, Option<String>>> constructHandlers() {
        return Cf.map("promo_name", this::getPromoName,
                "promo_to_date", this::getPromoToDate);
    }

    private Option<String> getPromoName(MailContext context) {
        if (context.getPromoId().isPresent() && context.getLanguage().isPresent()) {
            PromoTemplateEntity promoTemplateEntity = promoTemplateDao.findById(context.getPromoId().get());
            if (!promoTemplateEntity.getPromoNameTankerKey().isPresent()) {
                return Option.empty();
            }
            return textsManager.findTranslation(promoTemplateEntity.getPromoNameTankerKey().get())
                    .findLanguageTranslation(context.getLanguage().get().value());
        }
        return Option.empty();
    }

    private Option<String> getPromoToDate(MailContext context) {
        if (!context.getPromoId().isPresent()) {
            return Option.empty();
        }
        Option<Instant> promoToDate = promoTemplateDao.findById(context.getPromoId().get()).getToDate();
        // дату отображаем не включительно
        return formatDate(dateResolver, promoToDate.map(d -> d.minus(1)), context.getTo(), context.getLanguage());
    }
}

