package ru.yandex.chemodan.app.psbilling.core.mail.keydataproviders;

import java.util.UUID;
import java.util.function.Function;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.mail.MailContext;
import ru.yandex.chemodan.app.psbilling.core.mail.localization.DateResolver;
import ru.yandex.chemodan.app.psbilling.core.users.UserService;
import ru.yandex.chemodan.app.psbilling.core.users.UserServiceManager;

@AllArgsConstructor
public class SubscriptionInfoKeyDataProvider extends BaseEmailKeyDataProvider {
    private final DateResolver dateResolver;
    private final UserServiceManager userServiceManager;

    @Override
    protected MapF<String, Function<MailContext, Option<String>>> constructHandlers() {
        return Cf.map("subscription_end_date", this::getSubscriptionEndDate);
    }

    private Option<String> getSubscriptionEndDate(MailContext context) {
        return formatDate(
                dateResolver,
                context.getUserServiceId()
                        .map(UUID::fromString)
                        .map(userServiceManager::findById)
                        .flatMapO(UserService::getSubscriptionUntil),
                context.getTo(),
                context.getLanguage());
    }
}
