package ru.yandex.chemodan.app.psbilling.core.mail.keydataproviders;

import java.util.function.Function;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.mail.MailContext;

public class UidKeyDataProvider extends BaseEmailKeyDataProvider {

    @Override
    protected MapF<String, Function<MailContext, Option<String>>> constructHandlers() {
        return Cf.map("uid", this::getUid);
    }

    private Option<String> getUid(MailContext context) {
        return Option.of(String.valueOf(context.getTo().getUid()));
    }
}
