package ru.yandex.chemodan.app.psbilling.core.mail.keydataproviders;

import java.util.function.Function;

import lombok.AllArgsConstructor;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.dao.promos.UserPromoDao;
import ru.yandex.chemodan.app.psbilling.core.mail.MailContext;
import ru.yandex.chemodan.app.psbilling.core.mail.localization.DateResolver;

@AllArgsConstructor
public class UserPromoKeyProvider extends BaseEmailKeyDataProvider {
    private final DateResolver dateResolver;
    private final UserPromoDao userPromoDao;

    @Override
    protected MapF<String, Function<MailContext, Option<String>>> constructHandlers() {
        return Cf.map("user_promo_to_date", this::getUserPromoToDate);
    }

    private Option<String> getUserPromoToDate(MailContext context) {
        if (!context.getUserPromoId().isPresent()) {
            return Option.empty();
        }

        Option<Instant> toDateO = userPromoDao.findById(context.getUserPromoId().get()).getToDate();
        // отображаем дату не включительно
        return formatDate(dateResolver, toDateO.map(d -> d.minus(1)), context.getTo(), context.getLanguage());
    }
}
