package ru.yandex.chemodan.app.psbilling.core.mail.keydataproviders;

import java.util.function.Function;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.mail.MailContext;
import ru.yandex.inside.passport.blackbox2.Blackbox2;
import ru.yandex.inside.passport.blackbox2.protocol.response.BlackboxCorrectResponse;
import ru.yandex.inside.passport.blackbox2.protocol.response.BlackboxDbFields;
import ru.yandex.misc.net.LocalhostUtils;

@AllArgsConstructor
public class UserPublicNameKeyProvider extends BaseEmailKeyDataProvider {
    private final Blackbox2 blackbox2;

    @Override
    protected MapF<String, Function<MailContext, Option<String>>> constructHandlers() {
        return Cf.map("public_display_name", this::getPublicUserName);
    }

    private Option<String> getPublicUserName(MailContext context) {
        BlackboxCorrectResponse userInfoResponse = blackbox2.query().userInfo(
                LocalhostUtils.localAddress(),
                Option.of(context.getTo()),
                Option.empty(), Option.empty(),
                Cf.list(BlackboxDbFields.FIRSTNAME),
                Cf.list(),
                Option.empty(),
                Option.empty(),
                true,
                Option.empty(),
                false,
                true
        );
        String publicUserName = userInfoResponse
                .getDisplayName()
                .map(blackboxDisplayName -> blackboxDisplayName.getPublicName().orElse(blackboxDisplayName.getName()))
                .orElse(userInfoResponse.getDbFields().getO(BlackboxDbFields.FIRSTNAME).orElse(""));
        return Option.of(publicUserName);
    }
}
