package ru.yandex.chemodan.app.psbilling.core.mail.localization;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.ToString;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;

@NoArgsConstructor
@AllArgsConstructor
@ToString
@Getter
public class TermsLocalizationData {

    private MapF<String, TermLocalizationData> data = Cf.hashMap();

    @JsonAnySetter
    public void putField(String key, TermLocalizationData localizationData) {
        data.put(key, localizationData);
    }
}
