package ru.yandex.chemodan.app.psbilling.core.mail.tasks;

import org.joda.time.Duration;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.dao.mail.SentEmailInfoDao;
import ru.yandex.chemodan.app.psbilling.core.entities.mail.SentEmailInfoEntity;
import ru.yandex.chemodan.app.psbilling.core.mail.MailContext;
import ru.yandex.chemodan.app.psbilling.core.tasks.BaseTask;
import ru.yandex.chemodan.app.psbilling.core.tasks.execution.TaskExecutor;
import ru.yandex.chemodan.app.psbilling.core.tasks.policies.TaskPreExecutionPoliciesHolder;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

public class B2BTariffAcquisitionEmailTask extends BaseTask<B2BTariffAcquisitionEmailTask.Parameters> {
    private SentEmailInfoDao sentEmailInfoDao;

    public B2BTariffAcquisitionEmailTask(Parameters parameters) {
        super(parameters);
    }

    public B2BTariffAcquisitionEmailTask(TaskPreExecutionPoliciesHolder taskPreExecutionPoliciesHolder,
                                        ListF<TaskExecutor<?>> taskExecutors, SentEmailInfoDao sentEmailInfoDao) {
        super(taskPreExecutionPoliciesHolder, taskExecutors, B2BTariffAcquisitionEmailTask.Parameters.class);
        this.sentEmailInfoDao = sentEmailInfoDao;
    }

    @Override
    protected void execute(Parameters taskParams, ExecutionContext context) {
        PassportUid uid = taskParams.getContext().getTo();

        Option<SentEmailInfoEntity> sentAbandonedPaymentEmail = sentEmailInfoDao.find(uid.toString(),
                "b2b_admin_abandoned_payment");
        if (sentAbandonedPaymentEmail.isPresent()) {
            Instant scheduledTime = taskParams.scheduledTime;
            Instant abandonedPaymentEmailSentDate = sentAbandonedPaymentEmail.get().getSentDate();
            if (scheduledTime.isBefore(abandonedPaymentEmailSentDate)) {
                // уже отправили другое письмо после того, как запланировали это письмо
                logger.info("Cancelling b2b_tariff_acquisition email to {}: " +
                        "b2b_admin_abandoned_payment email was already sent", uid.toString());
                return;
            }
        }

        super.execute(taskParams, context);
    }

    @BenderBindAllFields
    public static class Parameters extends BaseEmailTask.Parameters {
        private final Instant scheduledTime;

        public Parameters(Instant scheduledTime, String emailKey, MailContext context,
                          String preExecutionPolicy, String executorKey, Option<Duration> cooldown) {
            super(emailKey, context, preExecutionPolicy, executorKey, cooldown);
            this.scheduledTime = scheduledTime;
        }
    }
}

