package ru.yandex.chemodan.app.psbilling.core.mail.tasks;


import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.RequiredArgsConstructor;
import org.joda.time.Duration;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.mail.MailContext;
import ru.yandex.chemodan.app.psbilling.core.tasks.BaseTask;
import ru.yandex.chemodan.app.psbilling.core.tasks.BaseTaskParams;
import ru.yandex.chemodan.app.psbilling.core.tasks.execution.TaskExecutor;
import ru.yandex.chemodan.app.psbilling.core.tasks.policies.TaskPreExecutionPoliciesHolder;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

public abstract class BaseEmailTask extends BaseTask<BaseEmailTask.Parameters> {
    protected BaseEmailTask(BaseEmailTask.Parameters parameters) {
        super(parameters);
    }

    protected BaseEmailTask(TaskPreExecutionPoliciesHolder taskPreExecutionPoliciesHolder,
                            ListF<TaskExecutor<?>> taskExecutors, Class<BaseEmailTask.Parameters> parametersClass) {
        super(taskPreExecutionPoliciesHolder, taskExecutors, parametersClass);
    }

    @BenderBindAllFields
    @Data
    @AllArgsConstructor
    @RequiredArgsConstructor
    public static class Parameters implements BaseTaskParams {
        private final String emailKey;
        private final MailContext context;
        private final String preExecutionPolicy;
        private final String executorKey;
        private Option<Duration> cooldown = Option.empty();

        public PassportUid getUser() {
            MailContext context = this.getContext();
            return PassportUid.cons(Long.parseLong(context.getTo().toString()));
        }
    }
}
