package ru.yandex.chemodan.app.psbilling.core.mail.tasks;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.psbilling.core.tasks.execution.TaskExecutor;
import ru.yandex.chemodan.app.psbilling.core.tasks.policies.TaskPreExecutionPoliciesHolder;
import ru.yandex.commune.bazinga.scheduler.ActiveUidBehavior;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDropType;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDuplicateBehavior;

public class SendLocalizedEmailTask extends BaseEmailTask {

    public SendLocalizedEmailTask(BaseEmailTask.Parameters parameters) {
        super(parameters);
    }

    public SendLocalizedEmailTask(TaskPreExecutionPoliciesHolder taskPreExecutionPoliciesHolder,
                                  ListF<TaskExecutor<?>> taskExecutors) {
        super(taskPreExecutionPoliciesHolder, taskExecutors, BaseEmailTask.Parameters.class);
    }

    @Override
    public ActiveUidBehavior activeUidBehavior() {
        return new ActiveUidBehavior(ActiveUidDropType.WHEN_FINISHED, ActiveUidDuplicateBehavior.MERGE);
    }
}
