package ru.yandex.chemodan.app.psbilling.core.mail.tasks;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.psbilling.core.synchronization.PsBillingQueueNames;
import ru.yandex.chemodan.app.psbilling.core.tasks.execution.TaskExecutor;
import ru.yandex.chemodan.app.psbilling.core.tasks.policies.TaskPreExecutionPoliciesHolder;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;

public class SendTransactionalEmailWithInvoiceCreationTask extends BaseEmailTask {

    public SendTransactionalEmailWithInvoiceCreationTask(BaseEmailTask.Parameters parameters) {
        super(parameters);
    }

    public SendTransactionalEmailWithInvoiceCreationTask(TaskPreExecutionPoliciesHolder taskPreExecutionPoliciesHolder,
                                                         ListF<TaskExecutor<?>> taskExecutors) {
        super(taskPreExecutionPoliciesHolder, taskExecutors, BaseEmailTask.Parameters.class);
    }

    @Override
    public TaskQueueName queueName() {
        return PsBillingQueueNames.SEND_TRANSACTIONAL_EMAILS_WITH_INVOICES;
    }
}
