package ru.yandex.chemodan.app.psbilling.core.products;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.BucketContentDao;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.spring.Service;
import ru.yandex.misc.worker.AlarmThread;

public class BucketContentManager implements Service {
    private static final Logger logger = LoggerFactory.getLogger(BucketContentManager.class);

    protected long delayMillis;

    private volatile ListF<SetF<String>> buckets;
    private volatile BucketContentTaskThread bucketContentTaskThread;

    private BucketContentDao bucketContentDao;

    public BucketContentManager(long delayMillis, BucketContentDao bucketContentDao) {
        this.delayMillis = delayMillis;
        this.bucketContentDao = bucketContentDao;
    }

    public void start() {
        if (bucketContentTaskThread == null) {
            bucketContentTaskThread = new BucketContentTaskThread();
            bucketContentTaskThread.start();
        }
    }

    public void stop() {
        if (bucketContentTaskThread != null) {
            bucketContentTaskThread.stopGracefully();
            bucketContentTaskThread = null;
        }
    }

    public ListF<SetF<String>> getBuckets() {
        if (buckets == null) {
            buckets = bucketContentDao.getBuckets();
        }
        return buckets;
    }

    public void refresh(){
        buckets = bucketContentDao.getBuckets();
    }

    private class BucketContentTaskThread extends AlarmThread {
        public BucketContentTaskThread() {
            super("BucketContentTaskFetcher", delayMillis);
        }

        @Override
        protected void beforeFirstExecution() throws Exception {
            logger.info("BucketContentTaskThread is running");
        }

        @Override
        protected void alarm() {
            buckets = bucketContentDao.getBuckets();
        }
    }

}
