package ru.yandex.chemodan.app.psbilling.core.products;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Objects;

import lombok.AccessLevel;
import lombok.RequiredArgsConstructor;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.texts.PredefinedTankerKey;

@RequiredArgsConstructor(access = AccessLevel.PRIVATE)
public enum ExperimentalProductFeature {
    EMPTY("", BigDecimal.ZERO, Option.empty());

    public final String code;
    public final BigDecimal amount;
    public final Option<PredefinedTankerKey> predefinedTankerKey;

    public static Option<ExperimentalProductFeature> find(String code, BigDecimal amount) {
        return Option.x(Arrays.stream(values()).filter(x -> x.code.equals(code) && Objects.equals(x.amount, amount)).findFirst());
    }
}
