package ru.yandex.chemodan.app.psbilling.core.products;

import java.util.UUID;

import lombok.RequiredArgsConstructor;

import ru.yandex.bolts.collection.SetF;
import ru.yandex.chemodan.app.psbilling.core.dao.products.ProductLineDao;
import ru.yandex.chemodan.app.psbilling.core.entities.products.ProductLineEntity;

@RequiredArgsConstructor
public class ProductLineService {
    private final ProductLineDao productLineDao;

    public SetF<UUID> getProductSetIds(SetF<UUID> productLineIds) {
        return productLineIds
                .map(productLineDao::findById)
                .map(ProductLineEntity::getProductSetId)
                .unique();
    }

}
