package ru.yandex.chemodan.app.psbilling.core.products;

import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.expression.BeanExpressionContextAccessor;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;


public class SpringExpressionEvaluator {
    private final ExpressionParser parser = new SpelExpressionParser();
    private final StandardEvaluationContext spElContext;
    private final BeanExpressionContext spElRootObject;

    public SpringExpressionEvaluator(ApplicationContext applicationContext) {
        StandardEvaluationContext context = new StandardEvaluationContext();
        context.setBeanResolver(new BeanFactoryResolver(applicationContext));
        context.addPropertyAccessor(new BeanExpressionContextAccessor());
        this.spElContext = context;
        this.spElRootObject = new BeanExpressionContext(
                (AbstractAutowireCapableBeanFactory) applicationContext.getAutowireCapableBeanFactory(), null);
    }

    public <T> T evaluateExpression(String expressionStr, Class<T> resultClass) {
        Expression expression = parser.parseExpression(expressionStr);
        return expression.getValue(spElContext, spElRootObject, resultClass);
    }
}
