package ru.yandex.chemodan.app.psbilling.core.products;

import java.math.BigDecimal;
import java.util.UUID;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.products.FeatureScope;
import ru.yandex.chemodan.app.psbilling.core.entities.products.ProductFeatureEntity;
import ru.yandex.chemodan.app.psbilling.core.texts.TankerTranslation;
import ru.yandex.inside.utils.Language;
import ru.yandex.misc.lang.DefaultObject;

public class UserProductFeature extends DefaultObject {
    private final ProductFeatureEntity entity;
    private final Option<TankerTranslation> description;
    private final Option<TankerTranslation> group;
    private final Option<TankerTranslation> value;

    UserProductFeature(ProductFeatureEntity entity, Option<TankerTranslation> description,
                       Option<TankerTranslation> group, Option<TankerTranslation> value) {
        this.entity = entity;
        this.description = description;
        this.group = group;
        this.value = value;
    }

    public Option<UUID> getFeatureId() {
        return entity.getFeatureId();
    }

    public Option<TankerTranslation> getDescription() {
        return description;
    }

    public Option<TankerTranslation> getGroup() {
        return group;
    }

    public Option<TankerTranslation> getValue() {
        return value;
    }

    public String getCode() {
        return entity.getCode();
    }

    public FeatureScope getScope() {
        return entity.getScope();
    }

    public int getOrderNum() {
        return entity.getOrderNum();
    }

    public Option<String> getEmailRepresentation(Language language, boolean appendValue) {
        Option<String> descriptionTranslation = description
                .flatMapO(tankerTranslation -> tankerTranslation.findLanguageTranslation(language.value()));
        if (!descriptionTranslation.isPresent()) {
            return Option.empty();
        }
        StringBuilder result = new StringBuilder();
        result.append(descriptionTranslation.get());
        if (appendValue) {
            value.flatMapO(tankerTranslation -> tankerTranslation.findLanguageTranslation(language.value()))
                    .ifPresent(valueTranslation -> result.append(" ").append(valueTranslation));
        }
        return Option.of(result).map(StringBuilder::toString);
    }

    public boolean isEnabled() {
        return this.entity.isEnabled();
    }

    public BigDecimal getAmount() {
        return entity.getAmount();
    }
}
