package ru.yandex.chemodan.app.psbilling.core.products;

public class UserProductFeatureRegistry {
    public final static String MPFS_SPACE_FEATURE_CODE = "mpfs_disk_space";
    public final static String MPFS_SPACE_FOR_B2B_FEATURE_CODE = "mpfs_disk_space_for_b2b_mail_360";
    public final static String FAN_MAIL_LIMIT_FEATURE_CODE = "fan_mail_limit";
    public final static String LETTER_ARCHIVE_ENABLED_FEATURE_CODE = "mail_b2b_letters_archive";
    public final static String LETTER_ARCHIVE_AVAILABLE_FEATURE_CODE = "mail_b2b_can_use_letters_archive";

    public static boolean isMpfsSpaceFeature(String featureCode) {
        return MPFS_SPACE_FEATURE_CODE.equals(featureCode)
                || MPFS_SPACE_FOR_B2B_FEATURE_CODE.equals(featureCode);
    }

    public static boolean isFanMailLimitFeature(String featureCode) {
        return FAN_MAIL_LIMIT_FEATURE_CODE.equals(featureCode);
    }

    public static boolean isLetterArchiveAvailableFeature(String featureCode) {
        return LETTER_ARCHIVE_AVAILABLE_FEATURE_CODE.equals(featureCode);
    }
}
