package ru.yandex.chemodan.app.psbilling.core.products;

import java.math.BigDecimal;
import java.util.Objects;
import java.util.UUID;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function0;
import ru.yandex.chemodan.app.psbilling.core.dao.products.UserProductPeriodDao;
import ru.yandex.chemodan.app.psbilling.core.dao.products.UserProductPricesDao;
import ru.yandex.chemodan.app.psbilling.core.entities.products.UserProductPriceEntity;
import ru.yandex.misc.lang.DefaultObject;

public class UserProductPrice extends DefaultObject {
    public static final String DEFAULT_REGION = "10000";
    public static final String DEFAULT_CURRENCY = "RUB";
    public static final String REGION_RUSSIA = "225";
    private final UserProductPriceEntity entity;
    private final Function0<UserProductPeriod> periodProvider;


    UserProductPrice(UserProductPriceEntity entity, UserProductPeriodDao userProductPeriodDao,
                     UserProductPricesDao userProductPricesDao, UserProductManager userProductManager) {
        this(entity, () -> new UserProductPeriod(
                userProductPeriodDao.findById(entity.getUserProductPeriodId()),
                userProductManager,
                userProductPricesDao));
    }

    UserProductPrice(UserProductPriceEntity entity, UserProductPeriod userProductPeriod) {
        this(entity, () -> userProductPeriod);
    }

    UserProductPrice(UserProductPriceEntity entity, Function0<UserProductPeriod> periodProvider) {
        this.entity = entity;
        this.periodProvider = periodProvider.memoize();
    }

    public UUID getId() {
        return entity.getId();
    }

    public UserProductPeriod getPeriod() {
        return periodProvider.apply();
    }

    public long getPeriodMsTo(Instant to) {
        return getPeriod().getPeriod().toJodaPeriod().toDurationTo(to).getMillis();
    }

    public BigDecimal getPrice() {
        return entity.getPrice();
    }

    public String getRegionId() {
        return entity.getRegionId();
    }

    public String getCurrencyCode() {
        return entity.getCurrencyCode();
    }

    public boolean isDefaultRegionPrice() {
        return Objects.equals(DEFAULT_REGION, entity.getRegionId());
    }

    public Option<BigDecimal> getDisplayDiscountPercent() {
        return entity.getDisplayDiscountPercent();
    }

    public Option<BigDecimal> getDisplayOriginalPrice() {
        return entity.getDisplayOriginalPrice();
    }

    public Option<BigDecimal> getStartPeriodPrice() {
        return entity.getStartPeriodPrice();
    }
}
