package ru.yandex.chemodan.app.psbilling.core.products.selectors;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.Group;
import ru.yandex.chemodan.app.psbilling.core.entities.products.ProductLineEntity;
import ru.yandex.inside.passport.PassportUid;

public abstract class AbstractAuthorizedUserSelector implements ProductLineSelector {

    @Override
    public ProductLineAvailability isAvailable(
            ProductLineEntity line, Option<PassportUid> uidO, Option<Group> group, SelectionContext selectionContext) {

        return uidO.map(uid -> isAvailable(line, uid, group, selectionContext)).orElse(ProductLineAvailability.UNAVAILABLE);
    }

    protected abstract ProductLineAvailability isAvailable(
            ProductLineEntity line,PassportUid uid, Option<Group> group, SelectionContext selectionContext);
}
