package ru.yandex.chemodan.app.psbilling.core.products.selectors;

import lombok.AllArgsConstructor;
import org.joda.time.LocalDateTime;
import org.joda.time.Period;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.Group;
import ru.yandex.chemodan.app.psbilling.core.entities.products.ProductLineEntity;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.inside.passport.blackbox2.Blackbox2;
import ru.yandex.inside.passport.blackbox2.protocol.response.BlackboxDbFields;
import ru.yandex.misc.net.LocalhostUtils;

@AllArgsConstructor
public class ByRegDateSelector extends AbstractAuthorizedUserSelector {

    private final Blackbox2 blackbox2;
    private final Period olderThanAge;
    private static final DateTimeFormatter passportRegDateFormat = DateTimeFormat.forPattern("YYYY-MM-dd HH:mm:ss");

    @Override
    public ProductLineAvailability isAvailable(ProductLineEntity line, PassportUid uid, Option<Group> group, SelectionContext selectionContext) {
        Option<String> regDate = selectionContext.getCachedValue("user." + uid + ".reg_date", () -> blackbox2.query()
                .userInfo(LocalhostUtils.localAddress(), uid, Cf.list(BlackboxDbFields.REG_DATE))
                .getDbFields().getO(BlackboxDbFields.REG_DATE));

        if (!regDate.isPresent()) {
            return ProductLineAvailability.UNAVAILABLE;
        }

        LocalDateTime registrationDate = LocalDateTime.parse(regDate.get(), passportRegDateFormat);
        return ProductLineAvailability.eternal(registrationDate.plus(olderThanAge).toDateTime().isBeforeNow());
    }
}
