package ru.yandex.chemodan.app.psbilling.core.products.selectors;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.Group;
import ru.yandex.chemodan.app.psbilling.core.entities.products.ProductLineEntity;
import ru.yandex.inside.passport.PassportUid;

public class CompositeAndSelector implements ProductLineSelector {
    private final ListF<ProductLineSelector> selectors;

    public CompositeAndSelector(ProductLineSelector ...selectors) {
        this.selectors = Cf.list(selectors);
    }

    @Override
    public ProductLineAvailability isAvailable(ProductLineEntity line, Option<PassportUid> uidO, Option<Group> group,
                                               SelectionContext selectionContext) {
        for (ProductLineSelector selector: selectors) {
            if (!selector.isAvailable(line, uidO, group, selectionContext).isAvailable()) {
                return ProductLineAvailability.UNAVAILABLE;
            }
        }

        return ProductLineAvailability.AVAILABLE;
    }
}
