package ru.yandex.chemodan.app.psbilling.core.products.selectors;

import lombok.AllArgsConstructor;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.Group;
import ru.yandex.chemodan.app.psbilling.core.entities.products.ProductLineEntity;
import ru.yandex.inside.passport.PassportUid;

@AllArgsConstructor
public class DelegateAvailableFromSelector implements ProductLineSelector {

    private final String fromDate;
    private final ProductLineSelector delegate;

    @Override
    public ProductLineAvailability isAvailable(
            ProductLineEntity line, Option<PassportUid> uid, Option<Group> group, SelectionContext selectionContext) {
        Instant from = LocalDate.parse(fromDate).toDateTime(LocalTime.MIDNIGHT, DateTimeZone.getDefault()).toInstant();
        if (from.isAfterNow()) {
            return ProductLineAvailability.UNAVAILABLE;
        }

        return delegate.isAvailable(line, uid, group, selectionContext);
    }
}
