package ru.yandex.chemodan.app.psbilling.core.products.selectors;

import lombok.AllArgsConstructor;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.Group;
import ru.yandex.chemodan.app.psbilling.core.entities.products.ProductLineEntity;
import ru.yandex.inside.passport.PassportUid;

@AllArgsConstructor
public class DelegateAvailableUntilSelector implements ProductLineSelector {

    private final String untilDate;
    private final ProductLineSelector delegate;

    @Override
    public ProductLineAvailability isAvailable(
            ProductLineEntity line, Option<PassportUid> uid, Option<Group> group, SelectionContext selectionContext) {
        Instant until = LocalDate.parse(untilDate).toDateTime(LocalTime.MIDNIGHT, DateTimeZone.getDefault()).toInstant();
        if (until.isBeforeNow()) {
            return ProductLineAvailability.UNAVAILABLE;
        }

        ProductLineAvailability lineAvailability =  delegate.isAvailable(line, uid, group, selectionContext);
        if (lineAvailability.isAvailable()) {
            return ProductLineAvailability.availableUntil(until);
        }
        return lineAvailability;
    }
}
