package ru.yandex.chemodan.app.psbilling.core.products.selectors;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.Group;
import ru.yandex.chemodan.app.psbilling.core.entities.products.ProductLineEntity;
import ru.yandex.chemodan.app.psbilling.core.groups.TrialService;
import ru.yandex.inside.passport.PassportUid;

@AllArgsConstructor
public class DelegateForNotUsedTrialSelector implements ProductLineSelector {

    private final String trialUsageComparisonKey;
    private final ProductLineSelector delegateIfNotUsed;
    private final TrialService trialService;

    @Override
    public ProductLineAvailability isAvailable(ProductLineEntity line, Option<PassportUid> uidO, Option<Group> group,
                                               SelectionContext selectionContext) {
        boolean isUsed = false;
        if (uidO.isPresent()) {
            isUsed = selectionContext.getCachedValue("user." + uidO + ".trial_used." + trialUsageComparisonKey,
                    () -> trialService.findUsageForUser(trialUsageComparisonKey, uidO.get()).isNotEmpty());
        }

        if (isUsed) {
            return ProductLineAvailability.UNAVAILABLE;
        }

        return delegateIfNotUsed.isAvailable(line, uidO, group, selectionContext);
    }
}
