package ru.yandex.chemodan.app.psbilling.core.products.selectors;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.Group;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.GroupType;
import ru.yandex.chemodan.app.psbilling.core.entities.products.ProductLineEntity;
import ru.yandex.chemodan.directory.client.DirectoryClient;
import ru.yandex.chemodan.directory.client.DirectoryOrganizationFeaturesResponse;
import ru.yandex.inside.passport.PassportUid;

@AllArgsConstructor
public class EducationalGroupProductSelector extends AbstractAuthorizedUserSelector {
    private final DirectoryClient directoryClient;

    @Override
    public  ProductLineAvailability isAvailable(ProductLineEntity line, PassportUid uid, Option<Group> group, SelectionContext selectionContext) {
        if (!group.isPresent() || group.get().getType() != GroupType.ORGANIZATION) {
            return ProductLineAvailability.UNAVAILABLE;
        }
        DirectoryOrganizationFeaturesResponse features = directoryClient.getOrganizationFeatures(group.get().getExternalId());
        if (features.isEdu360Active()) {
            return ProductLineAvailability.AVAILABLE;
        }
        return ProductLineAvailability.UNAVAILABLE;
    }
}
