package ru.yandex.chemodan.app.psbilling.core.products.selectors;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.Group;
import ru.yandex.chemodan.app.psbilling.core.entities.products.ProductLineEntity;
import ru.yandex.chemodan.app.uaas.experiments.ExperimentsManager;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

@AllArgsConstructor
public class ExperimentByOwnerIsActiveSelector implements ProductLineSelector {
    private static final Logger logger = LoggerFactory.getLogger(ExperimentByOwnerIsActiveSelector.class);
    private final String experiment;
    private final ExperimentsManager experimentsManager;

    @Override
    public ProductLineAvailability isAvailable(ProductLineEntity line, Option<PassportUid> uidO,
                                               Option<Group> groupO,
                                               SelectionContext selectionContext) {

        return groupO.map(group -> isAvailable(uidO, group, selectionContext))
                .orElse(ProductLineAvailability.UNAVAILABLE);
    }

    private ProductLineAvailability isAvailable(Option<PassportUid> uidO, Group group, SelectionContext selectionContext) {
        PassportUid ownerUid = group.getOwnerUid();
        ListF<String> userExperiments = selectionContext.getCachedValue("user." + ownerUid + ".experiment." + experiment,
                () -> getUserExperiments(ownerUid));

        if (userExperiments.containsTs(experiment)) {
            return ProductLineAvailability.AVAILABLE;
        }
        return ProductLineAvailability.UNAVAILABLE;
    }

    private ListF<String> getUserExperiments(PassportUid uid) {
        try {
            return experimentsManager.getFlags(uid.toUidOrZero().getUid());
        } catch (Exception e) {
            logger.info("Cannot fetch data from UaaS", e);
            return Cf.list();
        }
    }
}
