package ru.yandex.chemodan.app.psbilling.core.products.selectors;

import java.util.UUID;

import lombok.RequiredArgsConstructor;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.dao.products.UserProductDao;
import ru.yandex.chemodan.app.psbilling.core.entities.AbstractEntity;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.Group;
import ru.yandex.chemodan.app.psbilling.core.entities.products.ProductLineEntity;
import ru.yandex.chemodan.app.psbilling.core.users.UserServiceManager;
import ru.yandex.inside.passport.PassportUid;

@RequiredArgsConstructor
public class MissingConflictUserProductInLineSelector implements ProductLineSelector {

    private final ProductLineSelector delegateIfMissingConflict;
    private final UserServiceManager userServiceManager;
    private final UserProductDao userProductDao;

    @Override
    public ProductLineAvailability isAvailable(ProductLineEntity line, Option<PassportUid> uidO, Option<Group> group,
                                               SelectionContext selectionContext) {
        boolean missingConflict = uidO
                .map(uid -> {
                    ListF<UUID> productIds = userProductDao.findByProductLine(line.getId())
                            .map(AbstractEntity::getId);

                    return userServiceManager.findAllEnabledConflicting(uid.toString(), productIds).isEmpty();
                })
                .orElse(true);

        return missingConflict
                ? delegateIfMissingConflict.isAvailable(line, uidO, group, selectionContext)
                : ProductLineAvailability.UNAVAILABLE;
    }
}
