package ru.yandex.chemodan.app.psbilling.core.products.selectors;

import java.util.UUID;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.config.featureflags.FeatureFlags;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupServiceDao;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.BalancePaymentInfo;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.Group;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.GroupPaymentType;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.GroupService;
import ru.yandex.chemodan.app.psbilling.core.entities.products.ProductLineEntity;
import ru.yandex.inside.passport.PassportUid;

@AllArgsConstructor
public class PrepaidSelector implements ProductLineSelector {
    private GroupServiceDao groupServiceDao;
    private GroupDao groupDao;
    private FeatureFlags featureFlags;

    @Override
    public ProductLineAvailability isAvailable(ProductLineEntity line, Option<PassportUid> uidO, Option<Group> groupO,
                                               SelectionContext selectionContext) {
        if (!featureFlags.getPrepaidProducts().isEnabled()) {
            return ProductLineAvailability.UNAVAILABLE;
        }

        if (groupO.isEmpty() || uidO.isEmpty()) {
            return ProductLineAvailability.AVAILABLE;
        }

        Group group = groupO.get();
        PassportUid uid = uidO.get();

        PassportUid payerUid = group.getPaymentInfo().map(BalancePaymentInfo::getPassportUid).orElse(uid);
        ListF<UUID> checkGroupIds = groupDao.findGroupsByPaymentInfoUid(payerUid).map(Group::getId);

        ListF<GroupService> groupServices =
                groupServiceDao.findActiveGroupServicesByPaymentType(checkGroupIds, GroupPaymentType.POSTPAID);
        if (groupServices.filter(x -> !x.isHidden()).isNotEmpty()) {
            return ProductLineAvailability.UNAVAILABLE;
        }
        return ProductLineAvailability.AVAILABLE;
    }
}
