package ru.yandex.chemodan.app.psbilling.core.products.selectors;

import lombok.Getter;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;

/**
 * @author yashunsky
 */
@Getter
public class ProductLineAvailability {
    private final boolean available;
    private final Option<Instant> availableUntil;

    private ProductLineAvailability(boolean available, Option<Instant> availableUntil) {
        this.available = available;
        this.availableUntil = availableUntil;
    }

    public static ProductLineAvailability AVAILABLE = new ProductLineAvailability(true, Option.empty());

    public static ProductLineAvailability UNAVAILABLE = new ProductLineAvailability(false, Option.empty());

    public static ProductLineAvailability availableUntil(Instant until) {
        return new ProductLineAvailability(true, Option.of(until));
    }

    public static ProductLineAvailability eternal(boolean available) {
        return available ? AVAILABLE : UNAVAILABLE;
    }
}
