package ru.yandex.chemodan.app.psbilling.core.products.selectors;

import lombok.AllArgsConstructor;
import org.joda.time.Period;

import ru.yandex.chemodan.app.psbilling.core.config.featureflags.FeatureFlags;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupServiceDao;
import ru.yandex.chemodan.app.psbilling.core.dao.products.UserProductDao;
import ru.yandex.chemodan.app.psbilling.core.groups.TrialService;
import ru.yandex.chemodan.app.psbilling.core.users.UserServiceManager;
import ru.yandex.chemodan.app.uaas.experiments.ExperimentsManager;
import ru.yandex.chemodan.directory.client.DirectoryClient;
import ru.yandex.inside.passport.blackbox2.Blackbox2;

@AllArgsConstructor
public class ProductLineSelectorFactory {

    private final Blackbox2 blackbox2;
    private final TrialService trialService;
    private final DirectoryClient directoryClient;
    private final ExperimentsManager experimentsManager;
    private final GroupServiceDao groupServiceDao;
    private final GroupDao groupDao;
    private final FeatureFlags featureFlags;
    private final UserServiceManager userServiceManager;
    private final UserProductDao userProductDao;

    public ProductLineSelector regDateOlderThanSelector(Period age) {
        return new ByRegDateSelector(blackbox2, age);
    }

    public ProductLineSelector availableSelector() {
        return DefaultAvailableSelector.INSTANCE;
    }

    public ProductLineSelector unavailableSelector() {
        return DefaultUnavailableSelector.INSTANCE;
    }

    public ProductLineSelector onlyIfTrialNotUsed(String trialUsageComparisonKey, ProductLineSelector delegate) {
        return new DelegateForNotUsedTrialSelector(trialUsageComparisonKey, delegate, trialService);
    }

    public ProductLineSelector availableFromSelector(String fromDate, ProductLineSelector delegate) {
        return new DelegateAvailableFromSelector(fromDate, delegate);
    }

    public ProductLineSelector availableUntilSelector(String untilDate, ProductLineSelector delegate) {
        return new DelegateAvailableUntilSelector(untilDate, delegate);
    }

    public ProductLineSelector experimentIsActiveSelector(String experiment) {
        return new ExperimentIsActiveSelector(experiment, experimentsManager);
    }

    public ProductLineSelector experimentByOwnerIsActiveSelector(String experiment) {
        return new ExperimentByOwnerIsActiveSelector(experiment, experimentsManager);
    }

    public ProductLineSelector educationalGroupProductSelector() {
        return new EducationalGroupProductSelector(directoryClient);
    }

    public ProductLineSelector prepaidSelector() {
        return new PrepaidSelector(groupServiceDao, groupDao, featureFlags);
    }

    public ProductLineSelector compositeAndSelector(ProductLineSelector ...selectors) {
        return new CompositeAndSelector(selectors);
    }

    public ProductLineSelector missingConflictUserProductInLineSelector(ProductLineSelector selector){
        return new MissingConflictUserProductInLineSelector(selector, userServiceManager, userProductDao);
    }
}
