package ru.yandex.chemodan.app.psbilling.core.products.selectors;

import java.util.ArrayList;
import java.util.List;

import lombok.RequiredArgsConstructor;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.function.Function0;

@RequiredArgsConstructor
public class SelectionContext {
    private final MapF<String, Object> cachedValues = Cf.hashMap();
    private final List<String> productExperiments;

    public SelectionContext() {
        productExperiments = new ArrayList<>();
    }


    public <T> T getCachedValue(String key, Function0<T> valueProvider) {
        return (T) cachedValues.getOrElseUpdate(key, (Function0<Object>) valueProvider);
    }

    public List<String> getProductExperiments() {
        return productExperiments;
    }
}
