package ru.yandex.chemodan.app.psbilling.core.promocodes;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.Group;
import ru.yandex.chemodan.app.psbilling.core.model.RequestInfo;
import ru.yandex.chemodan.app.psbilling.core.promocodes.generator.PromoCodeGenerator;
import ru.yandex.chemodan.app.psbilling.core.promocodes.model.PromoCodeActivationResult;
import ru.yandex.chemodan.app.psbilling.core.promocodes.model.PromoCodeData;
import ru.yandex.chemodan.app.psbilling.core.promocodes.model.SafePromoCode;
import ru.yandex.chemodan.app.psbilling.core.promocodes.tasks.GeneratePromoCodeTask;
import ru.yandex.inside.passport.PassportUid;

public interface PromoCodeService {

    String RATE_LIMITER_DECORATOR = "rateLimitPromoCodeServiceDecorator";
    String IMPL = "promoCodeService";

    void blockPromoCode(SafePromoCode promoCode, String reason);

    PromoCodeActivationResult activatePromoCode(SafePromoCode promoCode, PassportUid uid, RequestInfo requestInfo);

    PromoCodeActivationResult activateGroupPromoCode(SafePromoCode promoCode, Group group, PassportUid uid, RequestInfo requestInfo);

    PromoCodeData canActivateGroupPromoCode(SafePromoCode promoCode, Option<Group> group, Option<PassportUid> uid, RequestInfo requestInfo);

    PromoCodeGenerator buildPromoCodeGenerator(GeneratePromoCodeTask.Parameters parameters);

    void scheduleGenerateAndPostPromoCodes(GeneratePromoCodeTask.Parameters parameters);
}
