package ru.yandex.chemodan.app.psbilling.core.promocodes;

import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.UUID;
import java.util.stream.StreamSupport;

import lombok.SneakyThrows;
import lombok.experimental.UtilityClass;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.IOUtils;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.chemodan.app.psbilling.core.promocodes.generator.PromoCodeGenerator;
import ru.yandex.chemodan.app.psbilling.core.promocodes.model.SafePromoCode;

@Slf4j
@UtilityClass
public class WriteToFilePromoCodes {

    @SneakyThrows
    public static void write(PromoCodeGenerator promoCodeGenerator) {
        Path path = Paths.get("promocodes_" + UUID.randomUUID() + "___" + Instant.now() + ".txt");
        try (Writer writer = Files.newBufferedWriter(path, StandardOpenOption.CREATE_NEW)) {
            StreamSupport.stream(Spliterators.spliteratorUnknownSize(promoCodeGenerator, Spliterator.ORDERED), false)
                    .peek(codes -> writeAll(codes, writer))
                    .count();

        }
        //Важная вещь для генерации. Файл достается исходя из лога
        log.info("No star trek ticket is specified. File {} will have to be delivered manually in a secure manner",
                path.toAbsolutePath()
        );
    }

    @SneakyThrows
    private void writeAll(CollectionF<SafePromoCode> codes, Writer writer) {
        IOUtils.writeLines(codes.map(SafePromoCode::getOriginalPromoCode), System.lineSeparator(), writer);
    }
}
