package ru.yandex.chemodan.app.psbilling.core.promocodes.activator;


import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.billing.users.UserBillingService;
import ru.yandex.chemodan.app.psbilling.core.dao.promocodes.GroupPromoCodeActivationDao;
import ru.yandex.chemodan.app.psbilling.core.dao.promocodes.UserPromoCodeDao;
import ru.yandex.chemodan.app.psbilling.core.dao.promos.UserPromoDao;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.Group;
import ru.yandex.chemodan.app.psbilling.core.products.UserProductManager;
import ru.yandex.chemodan.app.psbilling.core.promocodes.model.PromoCodeData;
import ru.yandex.chemodan.app.psbilling.core.promocodes.model.activator.AbstractPromoCodeActivator;
import ru.yandex.chemodan.app.psbilling.core.promocodes.model.activator.GroupPromoTemplatePromoCodeActivator;
import ru.yandex.chemodan.app.psbilling.core.promocodes.model.activator.UserProductPromoCodeActivator;
import ru.yandex.chemodan.app.psbilling.core.promocodes.model.activator.UserPromoTemplatePromoCodeActivator;
import ru.yandex.chemodan.app.psbilling.core.promos.PromoService;
import ru.yandex.chemodan.app.psbilling.core.promos.v2.GroupPromoService;
import ru.yandex.chemodan.app.psbilling.core.users.UserServiceManager;
import ru.yandex.inside.passport.PassportUid;

@Slf4j
@RequiredArgsConstructor
public class PromoCodeActivatorFactory {

    private final UserPromoCodeDao userPromoCodeDao;
    private final UserBillingService userBillingService;
    private final UserProductManager userProductManager;
    private final UserServiceManager userServiceManager;
    private final UserPromoDao userPromoDao;
    private final PromoService promoService;
    private final GroupPromoCodeActivationDao groupPromoCodeActivationDao;
    private final GroupPromoService groupPromoService;

    public AbstractPromoCodeActivator buildActivator(PromoCodeData promoCodeData, PassportUid uid, Option<Group> groupO) {
        switch (promoCodeData.getType()) {
            case B2B: {
                Group group = groupO
                        .orElseThrow(() -> new IllegalArgumentException("Group is required"));
                return buildB2bActivator(promoCodeData, group, uid);
            }
            case B2C:
                return buildB2cActivator(promoCodeData, uid);
            default:
                throw new IllegalStateException("Type is undefined " + promoCodeData.getType());
        }
    }

    private AbstractPromoCodeActivator buildB2bActivator(PromoCodeData promoCodeData, Group group, PassportUid uid) {
        if (promoCodeData.getPromoTemplateId().isPresent()) {
            return new GroupPromoTemplatePromoCodeActivator(
                    promoCodeData,
                    group,
                    uid,
                    groupPromoService,
                    groupPromoCodeActivationDao
            );
        }


        //do not return any detail about promo codes to client
        log.error("can not resolve promo code activator for " + promoCodeData);
        throw new IllegalStateException("Can not resolve promo code activator");
    }


    private AbstractPromoCodeActivator buildB2cActivator(PromoCodeData promoCodeData, PassportUid uid) {
        if (promoCodeData.getPromoTemplateId().isPresent()) {
            return new UserPromoTemplatePromoCodeActivator(
                    promoCodeData,
                    uid,
                    userPromoDao,
                    promoService,
                    userPromoCodeDao
            );
        }
        if (promoCodeData.getUserProductPriceId().isPresent()) {
            return new UserProductPromoCodeActivator(
                    promoCodeData,
                    uid,
                    userProductManager,
                    userServiceManager,
                    userBillingService,
                    userPromoCodeDao
            );
        }

        //do not return any detail about promo codes to client
        log.error("can not resolve promo code activator for " + promoCodeData);
        throw new IllegalStateException("Can not resolve promo code activator");
    }


}
