package ru.yandex.chemodan.app.psbilling.core.promocodes.impl;

import lombok.RequiredArgsConstructor;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.Group;
import ru.yandex.chemodan.app.psbilling.core.model.RequestInfo;
import ru.yandex.chemodan.app.psbilling.core.promocodes.PromoCodeService;
import ru.yandex.chemodan.app.psbilling.core.promocodes.generator.PromoCodeGenerator;
import ru.yandex.chemodan.app.psbilling.core.promocodes.model.PromoCodeActivationResult;
import ru.yandex.chemodan.app.psbilling.core.promocodes.model.PromoCodeData;
import ru.yandex.chemodan.app.psbilling.core.promocodes.model.SafePromoCode;
import ru.yandex.chemodan.app.psbilling.core.promocodes.tasks.GeneratePromoCodeTask;
import ru.yandex.inside.passport.PassportUid;

@RequiredArgsConstructor
public class RateLimitPromoCodeServiceDecorator implements PromoCodeService {

    private final PromoCodeService innerService;

    @Override
    public void blockPromoCode(SafePromoCode promoCode, String reason) {
        innerService.blockPromoCode(promoCode, reason);
    }

    @Override
    public PromoCodeActivationResult activatePromoCode(SafePromoCode promoCode, PassportUid uid, RequestInfo requestInfo) {
        //rateLimiter.checkLimit(uid, requestInfo);

        return innerService.activatePromoCode(promoCode, uid, requestInfo);
    }

    @Override
    public PromoCodeActivationResult activateGroupPromoCode(
            SafePromoCode promoCode,
            Group group, PassportUid uid,
            RequestInfo requestInfo
    ) {
        //rateLimiter.checkLimit(uid, requestInfo);

        return innerService.activateGroupPromoCode(promoCode, group, uid, requestInfo);
    }

    @Override
    public PromoCodeGenerator buildPromoCodeGenerator(GeneratePromoCodeTask.Parameters parameters) {
        return innerService.buildPromoCodeGenerator(parameters);
    }

    @Override
    public void scheduleGenerateAndPostPromoCodes(GeneratePromoCodeTask.Parameters parameters) {
        innerService.scheduleGenerateAndPostPromoCodes(parameters);
    }

    @Override
    public PromoCodeData canActivateGroupPromoCode(SafePromoCode promoCode, Option<Group> group,
                                                   Option<PassportUid> uid, RequestInfo requestInfo) {
        //rateLimiter.checkLimit(uid, requestInfo);

        return innerService.canActivateGroupPromoCode(promoCode, group, uid, requestInfo);
    }
}
