package ru.yandex.chemodan.app.psbilling.core.promocodes.model;

import lombok.AccessLevel;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

import ru.yandex.bolts.collection.Option;

@Getter
@RequiredArgsConstructor(access = AccessLevel.PRIVATE)
public class PromoCodeActivationResult {

    private final boolean activated;

    private final Option<PromoCodeActivationType> activationType;

    private final Option<PromoCodeActivationFail> fail;

    public static PromoCodeActivationResult activated(PromoCodeActivationType activationType) {
        return new PromoCodeActivationResult(true, Option.of(activationType), Option.empty());
    }

    public static PromoCodeActivationResult fail(PromoCodeActivationFail fail) {
        return new PromoCodeActivationResult(false, Option.empty(), Option.of(fail));
    }
}
