package ru.yandex.chemodan.app.psbilling.core.promocodes.model;

import java.sql.PreparedStatement;
import java.sql.SQLException;

import lombok.EqualsAndHashCode;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.jdbc.support.SqlValue;

import ru.yandex.bolts.function.Function0;


@EqualsAndHashCode(onlyExplicitlyIncluded = true)
public class SafePromoCode implements SqlValue {

    @EqualsAndHashCode.Include
    private final String code;

    private final Function0<String> toSafeFunction;
    private final String safeAlgorithm;

    private SafePromoCode(String code, Function0<String> toSafeFunction, String safeAlgorithm) {
        this.code = code;
        this.toSafeFunction = toSafeFunction.memoize();
        this.safeAlgorithm = safeAlgorithm;
    }

    public static SafePromoCode cons(String code) {
        return new SafePromoCode(code, () -> DigestUtils.sha1Hex(code), "sha1Hex");
    }

    public String getOriginalPromoCode() {
        return code;
    }


    public String getSafePromoCode() {
        return toSafeFunction.apply();
    }

    @Override
    public String toString() {
        return "SafePromoCode(" + safeAlgorithm + "=" + getSafePromoCode() + ')';
    }

    @Override
    public void setValue(PreparedStatement ps, int paramIndex) throws SQLException {
        ps.setString(paramIndex, code);
    }

    @Override
    public void cleanup() {

    }
}
