package ru.yandex.chemodan.app.psbilling.core.promocodes.model.activator;

import lombok.RequiredArgsConstructor;

import ru.yandex.chemodan.app.psbilling.core.promocodes.exception.PromoCodeCantBeActivatedException;
import ru.yandex.chemodan.app.psbilling.core.promocodes.model.PromoCodeData;

@RequiredArgsConstructor
public abstract class AbstractPromoCodeActivator implements PromoCodeDataActivator {

    private final PromoCodeData promoCodeData;

    protected abstract void activateImpl();

    @Override
    public final void activate() {
        if (!canBeActivated()) {
            throw new PromoCodeCantBeActivatedException();
        }
        activateImpl();
    }

    @Override
    public PromoCodeData getPromoCodeData() {
        return promoCodeData;
    }

    @Override
    public String toString() {
        return this.getClass() + "{" +
                "promoCode=" + promoCodeData.getCode() +
                '}';
    }
}
