package ru.yandex.chemodan.app.psbilling.core.promocodes.rule;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import ru.yandex.chemodan.app.psbilling.core.products.SpringExpressionEvaluator;
import ru.yandex.chemodan.app.psbilling.core.promocodes.model.PromoCodeData;

@Slf4j
@RequiredArgsConstructor
public class PromoCodeRuleCheckerEvaluate {
    private final PromoCodeRuleCheckerFactory promoCodeRuleCheckerFactory;
    private final SpringExpressionEvaluator evaluateExpression;

    public PromoCodeRuleChecker evaluateRuleChecker(PromoCodeData promoCodeData) {
        String ruleCheckerBeanEL = promoCodeData.getRuleCheckerBeanEl();
        if (StringUtils.isEmpty(ruleCheckerBeanEL)) {
            return promoCodeRuleCheckerFactory.available();
        }

        try {
            return evaluateExpression.evaluateExpression(ruleCheckerBeanEL, PromoCodeRuleChecker.class);
        } catch (Exception e) {
            log.error("Error during evaluating rule checker bean for promo code {}. promo code will be disabled", promoCodeData, e);
            return promoCodeRuleCheckerFactory.unavailable();
        }
    }

}
