package ru.yandex.chemodan.app.psbilling.core.promocodes.rule;

import lombok.RequiredArgsConstructor;

import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupProductDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupServiceDao;
import ru.yandex.chemodan.app.psbilling.core.dao.promos.PromoTemplateDao;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.GroupPaymentType;
import ru.yandex.chemodan.app.psbilling.core.promocodes.model.PromoCodeFailCodeEnum;
import ru.yandex.chemodan.app.psbilling.core.promocodes.rule.impl.AvailablePromoCodeRuleChecker;
import ru.yandex.chemodan.app.psbilling.core.promocodes.rule.impl.CompositeAndPromoCodeRuleChecker;
import ru.yandex.chemodan.app.psbilling.core.promocodes.rule.impl.ExceptEduPromoCodeRuleChecker;
import ru.yandex.chemodan.app.psbilling.core.promocodes.rule.impl.HaveDiscountOnMoreExpensiveGroupProductPromoCodeRuleChecker;
import ru.yandex.chemodan.app.psbilling.core.promocodes.rule.impl.OnlyEduPromoCodeRuleChecker;
import ru.yandex.chemodan.app.psbilling.core.promocodes.rule.impl.OnlyPaymentTypeOnGroupServicesPromoCodeRuleChecker;
import ru.yandex.chemodan.app.psbilling.core.promocodes.rule.impl.UnavailablePromoCodeRuleChecker;
import ru.yandex.chemodan.directory.client.DirectoryClient;

@RequiredArgsConstructor
public class PromoCodeRuleCheckerFactory {

    private final GroupServiceDao groupServiceDao;
    private final GroupProductDao groupProductDao;
    private final PromoTemplateDao promoTemplateDao;
    private final DirectoryClient directoryClient;

    public PromoCodeRuleChecker available() {
        return AvailablePromoCodeRuleChecker.INSTANCE;
    }

    public PromoCodeRuleChecker unavailable() {
        return UnavailablePromoCodeRuleChecker.INSTANCE;
    }

    public PromoCodeRuleChecker haveDiscountOnMoreExpensiveGroupProduct() {
        return new HaveDiscountOnMoreExpensiveGroupProductPromoCodeRuleChecker(
                groupServiceDao,
                groupProductDao,
                promoTemplateDao
        );
    }

    public PromoCodeRuleChecker onlyPostpaid() {
        return new OnlyPaymentTypeOnGroupServicesPromoCodeRuleChecker(
                groupServiceDao,
                GroupPaymentType.PREPAID,
                PromoCodeFailCodeEnum.ONLY_POSTPAID
        );
    }

    public PromoCodeRuleChecker onlyPrepaid() {
        return new OnlyPaymentTypeOnGroupServicesPromoCodeRuleChecker(
                groupServiceDao,
                GroupPaymentType.POSTPAID,
                PromoCodeFailCodeEnum.ONLY_PREPAID
        );
    }

    public PromoCodeRuleChecker onlyEdu() {
        return new OnlyEduPromoCodeRuleChecker(directoryClient);
    }

    public PromoCodeRuleChecker exceptEdu() {
        return new ExceptEduPromoCodeRuleChecker(directoryClient);
    }

    public PromoCodeRuleChecker compositeAndRuleChecker(PromoCodeRuleChecker... ruleCheckers) {
        return new CompositeAndPromoCodeRuleChecker(ruleCheckers);
    }
}
