package ru.yandex.chemodan.app.psbilling.core.promocodes.rule;

import lombok.AccessLevel;
import lombok.Data;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.promocodes.model.PromoCodeFailCodeEnum;

@Getter
@RequiredArgsConstructor(access = AccessLevel.PRIVATE)
public class PromoCodeRuleCheckerResult {

    private final boolean success;
    private final Option<Error> error;

    @Data
    public static class Error {
        private final PromoCodeFailCodeEnum errorCode;
    }

    public static PromoCodeRuleCheckerResult success() {
        return new PromoCodeRuleCheckerResult(true, Option.empty());
    }

    public static PromoCodeRuleCheckerResult fail(PromoCodeFailCodeEnum errorCode) {
        Error error = new Error(errorCode);
        return new PromoCodeRuleCheckerResult(false, Option.of(error));
    }
}
