package ru.yandex.chemodan.app.psbilling.core.promocodes.rule;

import lombok.Data;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.function.Function0;

@Data
public class PromoCodeRuleContext {
    private final MapF<String, Object> cachedValues = Cf.hashMap();

    public <T> T getCachedValue(String key, Function0<T> valueProvider) {
        return (T) cachedValues.computeIfAbsent(key, valueProvider.asFunction());
    }

}
