package ru.yandex.chemodan.app.psbilling.core.promocodes.rule;

import lombok.AccessLevel;
import lombok.Data;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

import ru.yandex.bolts.collection.Option;

@Getter
@RequiredArgsConstructor(access = AccessLevel.PRIVATE)
public class PromoCodeRuleResult {

    private final boolean success;
    private final Option<Error> error;

    @Data
    public static class Error {
        private final String message;
    }

    public static PromoCodeRuleResult success() {
        return new PromoCodeRuleResult(true, Option.empty());
    }

    public static PromoCodeRuleResult fail(String message) {
        Error error = new Error(message);
        return new PromoCodeRuleResult(false, Option.of(error));
    }
}
