package ru.yandex.chemodan.app.psbilling.core.promocodes.rule.impl;

import lombok.AccessLevel;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.Group;
import ru.yandex.chemodan.app.psbilling.core.promocodes.model.PromoCodeData;
import ru.yandex.chemodan.app.psbilling.core.promocodes.rule.PromoCodeRuleChecker;
import ru.yandex.chemodan.app.psbilling.core.promocodes.rule.PromoCodeRuleCheckerResult;
import ru.yandex.chemodan.app.psbilling.core.promocodes.rule.PromoCodeRuleContext;
import ru.yandex.inside.passport.PassportUid;

@Slf4j
@NoArgsConstructor(access = AccessLevel.PRIVATE)
public class AvailablePromoCodeRuleChecker implements PromoCodeRuleChecker {

    public static final AvailablePromoCodeRuleChecker INSTANCE = new AvailablePromoCodeRuleChecker();

    @Override
    public PromoCodeRuleCheckerResult check(
            PromoCodeData promoCodeData,
            Option<PassportUid> uidO,
            Option<Group> groupO,
            PromoCodeRuleContext context
    ) {
        log.debug("PromoCodeRuleChecker [Available] check for promoCodeData={} uidO={} groupO={} context={}", promoCodeData, uidO, groupO, context);
        return PromoCodeRuleCheckerResult.success();
    }
}
