package ru.yandex.chemodan.app.psbilling.core.promocodes.rule.impl;

import lombok.extern.slf4j.Slf4j;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.Group;
import ru.yandex.chemodan.app.psbilling.core.promocodes.model.PromoCodeData;
import ru.yandex.chemodan.app.psbilling.core.promocodes.rule.PromoCodeRuleChecker;
import ru.yandex.chemodan.app.psbilling.core.promocodes.rule.PromoCodeRuleCheckerResult;
import ru.yandex.chemodan.app.psbilling.core.promocodes.rule.PromoCodeRuleContext;
import ru.yandex.inside.passport.PassportUid;

@Slf4j
public class CompositeAndPromoCodeRuleChecker implements PromoCodeRuleChecker {

    private final ListF<PromoCodeRuleChecker> rules;

    public CompositeAndPromoCodeRuleChecker(PromoCodeRuleChecker... rules) {
        this.rules = Cf.list(rules);
    }

    @Override
    public PromoCodeRuleCheckerResult check(
            PromoCodeData promoCodeData,
            Option<PassportUid> uidO,
            Option<Group> groupO,
            PromoCodeRuleContext context
    ) {
        log.debug("PromoCodeRuleChecker [CompositeAnd] check for promoCodeData={} uidO={} groupO={} context={}", promoCodeData, uidO, groupO, context);

        for (PromoCodeRuleChecker rule : rules) {
            PromoCodeRuleCheckerResult result = rule.check(promoCodeData, uidO, groupO, context);

            if (!result.isSuccess()) {
                return result;
            }
        }

        return PromoCodeRuleCheckerResult.success();
    }

}
