package ru.yandex.chemodan.app.psbilling.core.promocodes.rule.impl;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.Group;
import ru.yandex.chemodan.app.psbilling.core.promocodes.model.PromoCodeData;
import ru.yandex.chemodan.app.psbilling.core.promocodes.model.PromoCodeFailCodeEnum;
import ru.yandex.chemodan.app.psbilling.core.promocodes.rule.PromoCodeRuleChecker;
import ru.yandex.chemodan.app.psbilling.core.promocodes.rule.PromoCodeRuleCheckerResult;
import ru.yandex.chemodan.app.psbilling.core.promocodes.rule.PromoCodeRuleContext;
import ru.yandex.chemodan.directory.client.DirectoryClient;
import ru.yandex.chemodan.directory.client.DirectoryOrganizationFeaturesResponse;
import ru.yandex.inside.passport.PassportUid;

@Slf4j
@RequiredArgsConstructor
public class OnlyEduPromoCodeRuleChecker implements PromoCodeRuleChecker {
    private final DirectoryClient directoryClient;

    @Override
    public PromoCodeRuleCheckerResult check(
            PromoCodeData promoCodeData,
            Option<PassportUid> uidO,
            Option<Group> groupO,
            PromoCodeRuleContext context
    ) {
        log.debug("PromoCodeRuleChecker [OnlyEdu] check for promoCodeData={} uidO={} groupO={} context={}",
                promoCodeData, uidO, groupO, context);

        Group group = groupO.orElseThrow(() -> new IllegalArgumentException("Group is required"));

        DirectoryOrganizationFeaturesResponse features = getOrganizationFeature(context, group);

        return features.isEdu360Active()
                ? PromoCodeRuleCheckerResult.success()
                : PromoCodeRuleCheckerResult.fail(PromoCodeFailCodeEnum.ONLY_EDU);
    }

    private DirectoryOrganizationFeaturesResponse getOrganizationFeature(PromoCodeRuleContext context, Group group) {
        return context.getCachedValue(
                "group." + group.getId() + ".organization_feature",
                () -> directoryClient.getOrganizationFeatures(group.getExternalId())
        );
    }
}
