package ru.yandex.chemodan.app.psbilling.core.promocodes.rule.impl;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupServiceDao;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.Group;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.GroupPaymentType;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.GroupService;
import ru.yandex.chemodan.app.psbilling.core.promocodes.model.PromoCodeData;
import ru.yandex.chemodan.app.psbilling.core.promocodes.model.PromoCodeFailCodeEnum;
import ru.yandex.chemodan.app.psbilling.core.promocodes.rule.PromoCodeRuleChecker;
import ru.yandex.chemodan.app.psbilling.core.promocodes.rule.PromoCodeRuleCheckerResult;
import ru.yandex.chemodan.app.psbilling.core.promocodes.rule.PromoCodeRuleContext;
import ru.yandex.inside.passport.PassportUid;

@Slf4j
@RequiredArgsConstructor
public class OnlyPaymentTypeOnGroupServicesPromoCodeRuleChecker implements PromoCodeRuleChecker {
    private final GroupServiceDao groupServiceDao;
    private final GroupPaymentType paymentType;
    private final PromoCodeFailCodeEnum failCode;

    @Override
    public PromoCodeRuleCheckerResult check(
            PromoCodeData promoCodeData,
            Option<PassportUid> uidO,
            Option<Group> groupO,
            PromoCodeRuleContext context
    ) {
        log.debug("PromoCodeRuleChecker [OnlyPaymentTypeOnGroupServices] check for promoCodeData={} uidO={} groupO={} context={} paymentType={}",
                promoCodeData, uidO, groupO, context, paymentType);

        Group group = groupO.orElseThrow(() -> new IllegalArgumentException("Group is required"));

        ListF<GroupService> groupServices = getGroupServiceWithPaymentType(context, group);

        return groupServices.exists(x -> !x.isHidden())
                ? PromoCodeRuleCheckerResult.fail(failCode)
                : PromoCodeRuleCheckerResult.success();
    }

    private ListF<GroupService> getGroupServiceWithPaymentType(PromoCodeRuleContext context, Group group) {
        return context.getCachedValue(
                "group." + group.getId() + ".group_services.enabled_" + paymentType.value(),
                () -> groupServiceDao.findActiveGroupServicesByPaymentType(Cf.list(group.getId()),
                        paymentType)
        );
    }
}
