package ru.yandex.chemodan.app.psbilling.core.promocodes.tasks;

import java.util.Set;

import lombok.Builder;
import lombok.Data;
import lombok.Singular;
import org.joda.time.Duration;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.promocodes.PromoCodeType;
import ru.yandex.chemodan.app.psbilling.core.promocodes.PromoCodeService;
import ru.yandex.chemodan.app.psbilling.core.promocodes.WriteToFilePromoCodes;
import ru.yandex.chemodan.app.psbilling.core.promocodes.generator.PromoCodeGenerator;
import ru.yandex.chemodan.app.psbilling.core.synchronization.PsBillingQueueNames;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

public class GeneratePromoCodeTask extends OnetimeTaskSupport<GeneratePromoCodeTask.Parameters> {

    private PromoCodeService promoCodeService;

    public GeneratePromoCodeTask(Parameters parameters) {
        super(parameters);
    }

    public GeneratePromoCodeTask(PromoCodeService promoCodeService) {
        super(Parameters.class);
        this.promoCodeService = promoCodeService;
    }

    @Override
    protected void execute(Parameters parameters, ExecutionContext context) throws Exception {
        PromoCodeGenerator generator = promoCodeService.buildPromoCodeGenerator(parameters);
        WriteToFilePromoCodes.write(generator);
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(60);
    }

    @Override
    public TaskQueueName queueName() {
        return PsBillingQueueNames.REGULAR;
    }

    @Data
    @Builder
    @BenderBindAllFields
    public static class Parameters {
        private final PromoCodeType type;
        @Builder.Default
        private final Option<String> productPeriodCodeO = Option.empty();
        @Builder.Default
        private final Option<String> promoTemplateCodeO = Option.empty();
        @Builder.Default
        private final Option<String> prefixO = Option.empty();
        @Singular(value = "addCode")
        private final Set<String> codes;
        private final int numToGenerate;
        @Builder.Default
        private final Option<Integer> numActivations = Option.empty();
        @Builder.Default
        private final Option<Instant> activeFromO = Option.empty();
        @Builder.Default
        private final Option<Instant> activeToO = Option.empty();
        private final String starTrekTicketId;
    }
}
