package ru.yandex.chemodan.app.psbilling.core.promocodes.validation;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.chemodan.app.psbilling.core.entities.promocodes.PromoCodeStatus;
import ru.yandex.chemodan.app.psbilling.core.promocodes.exception.PromoCodeCantBeActivatedException;
import ru.yandex.chemodan.app.psbilling.core.promocodes.model.PromoCodeData;
import ru.yandex.chemodan.util.date.DateTimeUtils;

@Slf4j
@RequiredArgsConstructor
public class PromoCodeValidator {

    public void validate(PromoCodeData promoCodeData) {
        if (promoCodeData.getStatus() != PromoCodeStatus.ACTIVE) {
            log.warn("Status of promo code is not active. Сan not activate {}", promoCodeData);
            throw new PromoCodeCantBeActivatedException();
        }
        if (promoCodeData.getRemainingActivations().orElse(1) <= 0) {
            log.warn("Remaining activations is le than zero. Сan not activate {}", promoCodeData);
            throw new PromoCodeCantBeActivatedException();
        }
        if (!DateTimeUtils.isNowInRange(promoCodeData.getFromDate(), promoCodeData.getToDate())) {
            log.warn("The current time is not the promo code activation interval. Сan not activate {}", promoCodeData);
            throw new PromoCodeCantBeActivatedException();
        }
    }

}
